<?php

class ExportExcel extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();

		require_once APPPATH.'third_party/PHPExcel_1.8.0_doc/Classes/PHPExcel/IOFactory.php';
		require_once APPPATH.'third_party/PHPExcel_1.8.0_doc/Classes/PHPExcel.php';
	}

	public function ExportHeaderAndBodyTRs()
	{
		if(!isset($_POST['tableBodyTRs']))
			$_POST['tableBodyTRs'] = [];
		if(!isset($_POST['Widths']))
			$_POST['Widths'] = [];
		
		$HTML = $this->load->view('export/excel/HeaderAndBodyTRs/index', array(), true);
	  //$HTML = str_replace( "&", "and", $HTML );
	    
    $HTML = str_replace( 
        "Π",//This is greek П 
        "П",//This is Macedonian П
        $HTML );
  	$s = trim($HTML);
  	$s = iconv("UTF-8", "UTF-8//IGNORE", $s); // drop all non utf-8 characters
  	
  	$s = preg_replace('/(?>[\x00-\x1F]|\xC2[\x80-\x9F]|\xE2[\x80-\x8F]{2}|\xE2\x80[\xA4-\xA8]|\xE2\x81[\x9F-\xAF])/', ' ', $s);
  	$s = preg_replace('/\s+/', ' ', $s); // reduce all multiple whitespace to a single space
  	$HTML = $s;
  	$HTML = iconv('UTF-8', 'UTF-8//IGNORE', $HTML);
  	
    $tmpfile = tempnam(sys_get_temp_dir(), 'html');
    file_put_contents($tmpfile, $HTML);

    $objPHPExcel     = new PHPExcel();
    $excelHTMLReader = PHPExcel_IOFactory::createReader('HTML');
    $excelHTMLReader->loadIntoExisting(
        //$tmpfile
        $tmpfile, 
        $objPHPExcel);

    //delete server file
    unlink($tmpfile);

    $sheet = $objPHPExcel->getActiveSheet();
    $sheet->removeRow(1);
    $sheet->removeColumn('A');
    $sheet->freezePane( 'B2' );
    //echo "[".date("F j,Y")." ".$_POST['FileName'].""."]";
    $sheet->setTitle(date("F j,Y")." ".$_POST['FileName']."");
    foreach($_POST['Widths'] AS $index=>$width)
    	$sheet->getColumnDimension( PHPExcel_Cell::stringFromColumnIndex($index) )->setWidth($width);

    $objPHPExcelWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
    $objPHPExcelWriter->save( $this->muser->GetFolder().$_POST['FileName'].'.xlsx' );

		echo json_encode( array(
			'post'=>$_POST,
			'url'=>$this->muser->GetFolderURL().$_POST['FileName'].'.xlsx',
			'path'=>$this->muser->GetFolder().$_POST['FileName'].'.xlsx'
		) );
	}

	public function DownloadExcel()
	{
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="'.$_GET['FileName'].'"');
    header('Cache-Control: max-age=0');
		readfile( $_GET['url'] );
		unlink( $_GET['path'] );
	}
}

?>