<?php
class MSSQLApp extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		if(!$this->muser->IsLogged())
			redirect(base_url('user/LoginPage'));
		if(in_array($this->muser->data()->type, [USER_TYPE_GUEST, USER_TYPE_OFFICE]) && $this->uri->segment(2)=='ViewTableData'
			&& ($this->uri->segment(5)=='' || $this->uri->segment(5)=='no' || $this->uri->segment(6)=='' || $this->uri->segment(6)=='no') )
			redirect( base_url('mssqlapp/TotalUsersTasks') );
		if($this->muser->data()->type==USER_TYPE_GUEST && $this->uri->segment(2)=='ListTablesForDatabase')
			redirect( base_url('') );
	}

	public function index()
	{
		if(in_array($this->muser->data()->type, [USER_TYPE_ADMIN, USER_TYPE_OFFICE]))
			redirect(base_url('mssqlapp/ListTablesForDatabase/A11898_ON'));
		else
			redirect(base_url('mssqlapp/TotalUsersTasks'));
		//$this->load->view('index/index');
	}

	public function ListTablesForDatabase($DatabaseTableName)
	{
		$this->load->view('database/all-tables/index');
	}

	public function ViewTableData($DatabaseTableName, $DBTableName, $PaginationRowIndex=0)
	{
		$this->load->view('database/view-table-data/index');
	}

	public function UsersEditor()
	{
		if(in_array($this->muser->data()->type, [USER_TYPE_ADMIN, USER_TYPE_OFFICE]))
			$this->load->view('users/users-editor/index');
		else
			redirect(base_url());
	}

	public function P404()
	{
		$this->load->view('404/index');
	}

	public function TotalUsersTasks()
	{
		$this->load->view('users/total-users-tasks/index');
	}
	public function TotalUsersTasks_LoadTotalUserTasks()
	{
		$DataStringJSON = file_get_contents( $_POST['dataURL'] );
		$GValues = json_decode( $DataStringJSON );
		echo json_encode(
			array(
				'values'=>$GValues,
				'post'=>$_POST
			)
		);
	}
}
?>